//================================================
// MPConvo mutator - Essential actor!
//
// This actor stores all mission progress
//
// It can also override the server host's game
// settings to force it to use the settings
// configured here, such as skills, augs, every
// player's appearance etc.
//===============================================
class MPConvo_Essential extends Mutator config(DeusEx);

var int missionState[128];

var() class<Pawn> PlayersAppearAs;
var() bool _bUseTheseSettings;
var() int SkillStartLevel;
var() int SkillPointsAtStart;
var() int SkillsPerKill; //can leave on, but getting from mission stuff is preferable
var() int AugsAtStart;
var() int AugsPerKill;

function PostBeginPlay()
{
	local DeusExMPGame dxmpg;

	Super.PostBeginPlay();

	Level.Game.BaseMutator.AddMutator(Self);

	if(_bUseTheseSettings)
	{
		foreach AllActors(class 'DeusExMPGame', dxmpg) //there's probably a better way of doing this... Oh well.
		{
			dxmpg.VictoryCondition = "Frags";
			dxmpg.ScoreToWin = 99999; //essentially an infinite game, until admin or mission servertravel
			//dxmpg.bFreezeScores = True; //investigate! maybe have option to freeze scores?

			dxmpg.MPSkillStartLevel = SkillStartLevel; //needs test. What is SkillsTotal?
			dxmpg.SkillsAvail = SkillPointsAtStart;
			dxmpg.SkillsPerKill = SkillsPerKill;
			dxmpg.InitialAugs = AugsAtStart;
			dxmpg.AugsPerKill = AugsPerKill;
		}
	}
}

function ModifyPlayer(Pawn Other)
{
	local MissionProgress MPA;

	if(PlayersAppearAs != None)
	{
		//won't mess with groundspeed yet, needs replicating iirc
		Other.Mesh=PlayersAppearAs.default.Mesh;
		Other.SetCollisionSize(PlayersAppearAs.default.CollisionRadius,PlayersAppearAs.default.CollisionHeight);
		Other.BaseEyeHeight=PlayersAppearAs.default.BaseEyeHeight;
		Other.AmbientSound=PlayersAppearAs.default.AmbientSound;
		Other.SoundRadius=PlayersAppearAs.default.SoundRadius;
		Other.SoundVolume=PlayersAppearAs.default.SoundVolume;
		Other.MultiSkins[0]=PlayersAppearAs.default.MultiSkins[0];
		Other.MultiSkins[1]=PlayersAppearAs.default.MultiSkins[1];
		Other.MultiSkins[2]=PlayersAppearAs.default.MultiSkins[2];
		Other.MultiSkins[3]=PlayersAppearAs.default.MultiSkins[3];
		Other.MultiSkins[4]=PlayersAppearAs.default.MultiSkins[4];
		Other.MultiSkins[5]=PlayersAppearAs.default.MultiSkins[5];
		Other.MultiSkins[6]=PlayersAppearAs.default.MultiSkins[6];
		Other.MultiSkins[7]=PlayersAppearAs.default.MultiSkins[7];
		Other.Texture=PlayersAppearAs.default.Texture;
		Other.drawScale=PlayersAppearAs.default.drawScale;
	}

	foreach AllActors(class'MissionProgress',MPA)
	{
		if(MPA.Owner == Other) //check if we already own one (just respawned)
		{
			return;
		}
		else if(MPA.ownerName == DeusExPlayer(Other).PlayerReplicationInfo.PlayerName) //check if we're a returning player (just rejoined)
		{
			MPA.SetOwner(Other);
			return;
		}
	}

	//we don't have an MPA, so make one!
	Spawn(class'MissionProgress', Other,,);
}

function Mutate (String S, PlayerPawn Player)
{
	local int i;
	local MPConvoPawn mpcp;
	local MPConvo_Trigger mpct;

	if(mid(S, 0, 17) ~= "mpconvo.backupsys")
	{
		broadcastmessage("|p2MPConvo backup system! Using ClientMessage()   :(");

		foreach AllActors(class'MPConvoPawn',mpcp)
		{
			mpcp.bBackupSys = true;
		}
	}

	if(mid(S, 0, 13) ~= "mpconvo.about")
	{
		DeusExPlayer(Player).ClientMessage("|p7MPConversations Version 1.0 - Created by Cozmo");
		DeusExPlayer(Player).ClientMessage("|p7Find out more at gravity-world.com");
	}

	if((mid(S, 0, 15) ~= "mpconvo.credits") || (mid(S, 0, 7) ~= "credits"))
	{
		DeusExPlayer(Player).ClientMessage("|p1You have "$DeusExPlayer(Player).Credits$" credits");
	}

	if(mid(S, 0, 13) ~= "mpconvo.debug") //find every actor in a mission, and dump it into the log. Useful for keeping track or debugging (Note: UNTESTED!!)
	{
		if(Player.bAdmin == true) //intensive function; could be abused (log spam + foreach), so only admins can use
		{
			log("===================================");
			log("MPConversations v1 - DEBUGGING!");
			log("===================================");
			log(" ");

			for(i=0; i<128; i++)
			{
				if(i==0)
				{
					log("Mission: 0 (Remember that mission 0 cannot ever change state! Only for odd NPCs, shops etc)");
				}
				else
				{
					log("Mission: "$i);
				}

				log("Pawns:");

				foreach AllActors(class'MPConvoPawn',mpcp)
				{
					if(mpcp.MissionNumber == i)
					{
						log("  Pawn "$mpcp.PawnName$" is part of mission "$i);
					}
				}

				log("Triggers:");

				foreach AllActors(class'MPConvo_Trigger',mpct)
				{
					if(mpct.MissionNumber == i)
					{
						log("  "$mpct.Name$", tagged "$mpct.Tag$" is part of mission "$i);
						log("    this trigger checks for state "$mpct.CheckMissionState$" and sets to "$mpct.setMissionState);
					}
				}

				log(" "); //line breaks
			}
		}
	}
}

function int GetMissionState(int mission) //copied from MissionProgress (for co-op ONLY)
{
	//protection removed, because MissionProgress does that for us already
	return missionState[mission];
}

function SetMissionState(int mission, int setState) //doesn't need mission 0 protection; other class does that for us
{
	missionState[mission] = setState;
}

defaultproperties
{
     SkillStartLevel=1
     SkillPointsAtStart=2000
     AugsAtStart=2
     SkillsPerKill=0;
}
